<?php
/*--------------------------------------------------------------
   Mapper.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Data;

use Gambio\Admin\Modules\Statistics\App\Overview\Factory;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\WidgetDefinitions;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Widgets;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\Widget;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDatabaseEntry;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\WidgetDefinition;

class Mapper
{
    /**
     * @var Factory
     */
    private $factory;
    
    
    /**
     * Constructor.
     */
    public function __construct(Factory $factory)
    {
        $this->factory = $factory;
    }
    
    
    /**
     * Return widget by mapping widget database entry and widget definition.
     */
    public function mapToWidget(WidgetDatabaseEntry $databaseEntry, WidgetDefinition $definition): Widget
    {
        $options = $this->factory->useOptions()->createOptionsFromUpdateSet($databaseEntry->updateSet(), $definition);
        
        return $this->factory->createWidget($databaseEntry->id(),
                                            $databaseEntry->label(),
                                            $definition->icon(),
                                            $databaseEntry->width(),
                                            $databaseEntry->height(),
                                            $databaseEntry->horizontalPosition(),
                                            $databaseEntry->verticalPosition(),
                                            $definition->visualization(),
                                            $options,
                                            $definition->data($options));
    }
    
    
    /**
     * Return widgets by mapping widget database entries and widget definitions.
     */
    public function mapToWidgets(array $databaseEntries, WidgetDefinitions $definitions): Widgets
    {
        return $this->factory->createWidgets(...
            array_map(function (array $databaseEntry) use ($definitions) {
                $typedDatabaseEntry = $this->mapToWidgetDatabaseEntry($databaseEntry);
                $definition         = $definitions->getByType($typedDatabaseEntry->type());
                
                return $this->mapToWidget($typedDatabaseEntry, $definition);
            },
                $databaseEntries));
    }
    
    
    /**
     * Return widget database entry.
     */
    public function mapToWidgetDatabaseEntry(array $databaseEntry): WidgetDatabaseEntry
    {
        return $this->factory->createWidgetDatabaseEntry($this->factory->createType($databaseEntry["type"]),
                                                         $this->factory->createLabel($databaseEntry["label"]),
                                                         $this->factory->createWidth($databaseEntry["width"]),
                                                         $this->factory->createHeight($databaseEntry["height"]),
                                                         $this->factory->createHorizontalPosition($databaseEntry["horizontalPosition"]),
                                                         $this->factory->createVerticalPosition($databaseEntry["verticalPosition"]),
                                                         $this->factory->useOptions()
                                                             ->createUpdateSet($databaseEntry["options"]),
                                                         $this->factory->createId($databaseEntry["_id"]));
    }
}